/*~~~~~~~~~~~~~~~~~~~~~~~~~*\
 * terminal block
\*~~~~~~~~~~~~~~~~~~~~~~~~~*/

function buildSearchMask(winRef) {
	if(searchMode == null) return;
	if(searchMode != "standard") buildCustomizedSearchInputMask(winRef);
	else { // default behavior
		if(interpartsVersion == "dynamic") buildDynamicSearchInputMask(winRef);
		else buildStaticSearchInputMask(winRef);
	}
}


function search_searchInit(winRef) {
	if(searchMode == null) return;
	if(searchMode != "standard") customizedSearchInit(winRef);
	else { // default behavior
		if(interpartsVersion == "dynamic") dynamicSearchInit(winRef);
		else staticSearchInit(winRef);
	}
}


function search_startSearch(winRef) {
	if(searchMode == null) return;
	if(searchMode != "standard") customizedStartSearch(winRef);
	else { // default behavior
		if(interpartsVersion == "dynamic") dynamicStartSearch(winRef);
		else staticStartSearch(winRef);
	}
}


var search_currentChoice = null;
belenusHome.searchBelowSelectedTreeEntryState = (belenusHome.searchBelowSelectedTreeEntry == true) ? true : false;
/*~~~~~~~~~~~~~~~~~~~~~~~~~*\
 * 4 static&dynamic part functions
\*~~~~~~~~~~~~~~~~~~~~~~~~~*/

function buildDynamicSearchInputMask(winRef) {
	var d = winRef.document;
	d.write('<table border="0" class="dynamicSearchInputMask" cellpadding="0" cellspacing="0">');
	d.write('<tr>');

	d.write('<td class="dynamicSearchInputDropdown" width="1">');
	d.write('<select id="SDD" onchange="belenusHome.search_showSearchOption(self,this.options[this.selectedIndex].value)">');
	for(sd in dynamic_searchFields) {
		var label = (belenusHome.ld[dynamic_searchFields[sd][0]]) ? belenusHome.ld[dynamic_searchFields[sd][0]] : dynamic_searchFields[sd][0];
		d.write('<option value="'+dynamic_searchFields[sd][1]+'" id="'+belenusHome.addLKey("a55"+sd+""+Math.random(),winRef,"",dynamic_searchFields[sd][0])+'">'+label+'</option>');
	}
	d.write("</select>");
	d.write('</td>');

	d.write('<td class="dynamicSearchInputFields" width="1">');
	for(sd in dynamic_searchFields) {
		var maxLength = (getQueryField(dynamic_searchFields[sd][1], "maxlength")) ? getQueryField(dynamic_searchFields[sd][1], "maxlength") : "40";
		var inputCheck = (getQueryField(dynamic_searchFields[sd][1], "inputCheck")) ? getQueryField(dynamic_searchFields[sd][1], "inputCheck") : "notEmpty";
		d.write('<span id="'+dynamic_searchFields[sd][1]+'" style="display:none"><input type="text" size="30" value="" inputCheck="'+inputCheck+'"  maxlength="'+maxLength+'" id="'+dynamic_searchFields[sd][1]+'_0"></span>');
	}
	d.write('</td>');

	d.write('<td class="dynamicSearchInputButton" width="1">');
	d.write('<table border="0" cellpadding="0" cellspacing="0" class="tab"><tr>');
	d.write('<td nowrap>');
	d.write('<img src="'+belenusHome.getPath('custom/images/i.gif')+'" height="10" width="4">');
	if(searchBelowSelectedTreeEntry != null)
		d.write('<img title="'+belenusHome.ld['s_belowFolder']+'" id="'+belenusHome.addLKey("a88",winRef,"title","s_belowFolder")+'" src="'+belenusHome.getPath('custom/images/treebelow_tt_'+((belenusHome.searchBelowSelectedTreeEntryState == true) ? 'on' : 'off')+'.gif')+'" height="16" width="36" align="absmiddle" vspace="0" hspace="0" border="0" onclick="belenusHome.searchBelowSelectedTreeEntryState=!belenusHome.searchBelowSelectedTreeEntryState;this.src=belenusHome.getPath(\'custom/images/treebelow_tt_\'+((belenusHome.searchBelowSelectedTreeEntryState == true) ? \'on\' : \'off\')+\'.gif\')">');
	var standardSearchIMG = 	(searchBelowSelectedTreeEntry != null) ? "" : '<img src="'+belenusHome.getPath('custom/images/search.gif')+'" width="18" height="16" border="0" align="absmiddle">';
	d.write('<a onmouseover="top.status=belenusHome.ld.nav_search;return true;"'+
	' onmouseout="top.status=\'\';return true;" onclick="belenusHome.search_startSearch(self)" href="javascript://" id="'+belenusHome.addLKey(Math.random(),winRef,"title","submitBtn")+'" title="'+belenusHome.ld['submitBtn']+'" >'+ standardSearchIMG +
	'<span id="'+belenusHome.addLKey("a56",winRef,"","submitBtn")+'">'+belenusHome.ld['submitBtn']+'</span><img src="'+belenusHome.getPath('custom/images/i.gif')+'" height="8" width="8" border="0"></a>');
	d.write('<img src="'+belenusHome.getPath('custom/images/i.gif')+'" height="10" width="8"></td>');
	d.write('</tr></table>');


	d.write('</td>');
	d.write('</tr>');
	d.write('</table>');
}

function buildStaticSearchInputMask(winRef) {
	var d = winRef.document;
	d.write('<table class="staticSearchInputMask" cellpadding="0" cellspacing="0">');
	d.write('<tr>');

	d.write('<td class="staticSearchInputDropdown">');
	d.write('<select id="SDD" onchange="belenusHome.search_showSearchOption(self,this.options[this.selectedIndex].value)">');
	for(sd in static_searchFields) {
		var label = (belenusHome.ld[static_searchFields[sd][0]]) ? belenusHome.ld[static_searchFields[sd][0]] : static_searchFields[sd][0];
		d.write('<option value="'+static_searchFields[sd][1]+'" id="'+belenusHome.addLKey("a57"+sd+""+Math.random(),winRef,"",static_searchFields[sd][0])+'">'+label+'</option>');
	}
	d.write("</select>");
	d.write('</td>');

	d.write('<td class="staticSearchInputFields">');
	for(sd in static_searchFields) {
		var maxLength = (getQueryField(static_searchFields[sd][1], "maxlength")) ? getQueryField(static_searchFields[sd][1], "maxlength") : "40";
		var inputCheck = (getQueryField(static_searchFields[sd][1], "inputCheck")) ? getQueryField(static_searchFields[sd][1], "inputCheck") : "notEmpty";
		d.write('<span id="'+static_searchFields[sd][1]+'" style="display:none"><input type="text" size="30" value="" inputCheck="'+inputCheck+'"  maxlength="'+maxLength+'" id="'+static_searchFields[sd][1]+'_0"></span>');
	}
	d.write('</td>');

	d.write('<td class="staticSearchInputButton">');
	d.write('<table border="0" cellpadding="0" cellspacing="0" class="tab"><tr>');
	d.write('<td nowrap>');
	d.write('<img src="'+belenusHome.getPath('custom/images/i.gif')+'" height="10" width="4">');
	if(searchBelowSelectedTreeEntry != null)
	d.write('<img title="'+belenusHome.ld['s_belowFolder']+'" id="'+belenusHome.addLKey("a88",winRef,"title","s_belowFolder")+'" src="'+belenusHome.getPath('custom/images/treebelow_tt_'+((belenusHome.searchBelowSelectedTreeEntryState == true) ? 'on' : 'off')+'.gif')+'" height="16" width="36" align="absmiddle" vspace="0" hspace="0" border="0" onclick="belenusHome.searchBelowSelectedTreeEntryState=!belenusHome.searchBelowSelectedTreeEntryState;this.src=belenusHome.getPath(\'custom/images/treebelow_tt_\'+((belenusHome.searchBelowSelectedTreeEntryState == true) ? \'on\' : \'off\')+\'.gif\')">');	
	d.write('<a onmouseover="top.status=belenusHome.ld.nav_search;return true;" onmouseout="top.status=\'\';return true;" onclick="belenusHome.search_startSearch(self)" href="javascript://"><img src="'+belenusHome.getPath('custom/images/search.gif')+'" width="18" height="16" border="0" align="absmiddle">');
	d.write('<span id="'+belenusHome.addLKey("a58",winRef,"","submitBtn")+'">'+belenusHome.ld['submitBtn']+'</span><img src="'+belenusHome.getPath('custom/images/i.gif')+'" height="8" width="8" border="0"></a>');
	d.write('<img src="'+belenusHome.getPath('custom/images/i.gif')+'" height="10" width="8"></td>');
	d.write('</tr></table>');

	d.write('</td>');
	d.write('</tr>');
	d.write('</table>');
}


var searchID = 3.141592;
function dynamicSearchInit(winRef) {
	search_showSearchOption(winRef,dynamic_searchFields[preSelectSearchIndex_dynamic][1]);
}

function staticSearchInit(winRef) {
	search_showSearchOption(winRef,static_searchFields[preSelectSearchIndex_static][1]);
}


function dynamicStartSearch(winRef) {
	searchID = (belenusHome.useTabManager) ? searchID+1 : searchID;
	var treePath = belenusHome.currentTreePath;
	var treeID = treePath.split("/");
	if(treeID.length >= 1 && belenusHome.searchBelowSelectedTreeEntryState == true) {
		treeID.reverse();
		treeID = treeID[0];
	} else {
	  treeID = "";
	  treePath = "";
	}

	var searchRequestStr = "resultid="+ searchID +"&restart=true&treeid=" + treeID + "&treepath=" + treePath;
	// set display js libary
	searchRequestStr += "&jsfile=";
	searchRequestStr += (belenusHome.searchDisplayFn != null) ? belenusHome.searchDisplayFn : "js/dyn_search.js";
	// set display css libary
	searchRequestStr += "&cssfile=";
	searchRequestStr += (belenusHome.searchDisplayCSS != null) ? belenusHome.searchDisplayCSS : "custom/searchresult.css";

	var value = belenusHome.id(winRef.document,search_currentChoice+"_0").value;
	if(value == "") {
		winRef.alert(belenusHome.ld['s_uncompleted']);
		search_showSearchOption(winRef,search_currentChoice);
		return;
	}
	var cTy = belenusHome.id(winRef.document,search_currentChoice+"_0").getAttribute('inputCheck'); // checkType
	if(!belenusHome.usrInputCheck(winRef,belenusHome.id(winRef.document,search_currentChoice+"_0").getAttribute('inputCheck'),value)) {
		if(cTy == "notEmpty" || cTy == "alphaNum") winRef.alert(belenusHome.ld['s_uncompleted']);
		search_showSearchOption(winRef,search_currentChoice);
		return;
	}
	if(value.indexOf("#")!=-1||value.indexOf("&")!=-1||value.indexOf("=")!=-1||value.indexOf("?")!=-1)
		searchRequestStr += "&parameter0="+encodeURIComponent(value); // war mal mit escape(value) eingetragen, keiner weiss wieso
	else
		searchRequestStr += "&parameter0="+encodeURIComponent(value);
	var caption = "&tabCaption=";
	var label = "";
	var labelKey = "";
	for(i in dynamic_searchFields) {
		if(dynamic_searchFields[i][1] == search_currentChoice) {
			label = (belenusHome.ld[dynamic_searchFields[i][0]]) ? belenusHome.ld[dynamic_searchFields[i][0]] : escape(dynamic_searchFields[i][0]);
			labelKey = (belenusHome.ld[dynamic_searchFields[i][0]]) ? dynamic_searchFields[i][0] : "";
			break;
		}
	}
//	caption += escape("longTabCaption=<span "+escape(escape('id='+id4MultiLangLabel0))+">"+belenusHome.ld['nav_search']+ '</span> ( <span '+escape(escape('id='+id4MultiLangLabel1))+'>'+label+'</span>: '+value+' )&shortTabCaption=<span '+escape(escape('id='+id4MultiLangLabel2))+'>'+belenusHome.ld['nav_search']+"</span> ( "+value+" )");
//	caption += escape("longTabCaption="+belenusHome.ld['nav_search']+ ' ( '+label+':'+value+' )&shortTabCaption='+belenusHome.ld['nav_search']+" ( "+value+" )");
//	caption += escape("longTabCaption="+escape('document.write(\'xxx\')')+' ( '+label+':'+value+' )&shortTabCaption='+belenusHome.ld['nav_search']+" ( "+value+" )");
	caption += escape("longTabCaption=belenusHome.ld['nav_search']+' ( '+belenusHome.ld[\""+labelKey+"\"]+': "+((value.indexOf("&")!=-1 || value.indexOf("=")!=-1)?escape(value):value)+" )'&shortTabCaption=belenusHome.ld['nav_search']+' ( "+((value.indexOf("&")!=-1 || value.indexOf("=")!=-1)?escape(value):value)+" )'");
	searchRequestStr += caption;

	var multipleSearchs = false;
	for(i2 in dynamic_searchFields) {
		if(dynamic_searchFields[i2][1] == search_currentChoice) {
			if(typeof dynamic_searchFields[i2][3] != "undefined" && typeof dynamic_searchFields[i2][3] == "object") {
				multipleSearchs = ""+i2;
				break;
			}
		}
	}
	if(!multipleSearchs) {
		if(belenusHome.useTabManager == false || belenusHome.Windows['searchX'][5] == "")
			try {
				if(belenusHome.WM.getWindowReference('searchX').closed == false) belenusHome.WM.closeWindow('searchX');
			} catch(e) {}
		belenusHome.WM.openWindow('searchX',searchRequestStr+"&"+search_currentChoice,false);
	} else {
		if(belenusHome.useTabManager) {
			belenusHome.WM.openWindow('searchX',searchRequestStr+"&"+search_currentChoice,false);
			for(multiSearch in dynamic_searchFields[multipleSearchs][3]) {
				belenusHome.WM.openWindow('searchX',searchRequestStr+"&"+dynamic_searchFields[multipleSearchs][3][multiSearch],false);
			}
		} else alert("TabManager is inactive, can't start multiple searchs!");
	}


}

function staticStartSearch(winRef) {
	var searchRequestStr = "";
	var value = belenusHome.id(winRef.document,search_currentChoice+"_0").value;
		
	if(value == "") {
		winRef.alert(belenusHome.ld['s_uncompleted']);
		search_showSearchOption(winRef,search_currentChoice);
		return;
	}
	
	var treePath = belenusHome.currentTreePath;
	var treeID = treePath.split("/");
	if(treeID.length >= 1 && belenusHome.searchBelowSelectedTreeEntryState == true) {
		treeID.reverse();
		treeID = treeID[0];
	} else {
	  treeID = "";
	  treePath = "";
	}
	searchRequestStr += "treepath=" + treePath.substring(1);
	var cTy = belenusHome.id(winRef.document,search_currentChoice+"_0").getAttribute('inputCheck');
	if(!belenusHome.usrInputCheck(winRef,belenusHome.id(winRef.document,search_currentChoice+"_0").getAttribute('inputCheck'),value)) {
		//if(cTy == "notEmpty" || cTy == "alphaNum") winRef.alert(belenusHome.ld['s_uncompleted']);
		search_showSearchOption(winRef,search_currentChoice);
		return;
	}
	if(value.indexOf("#")!=-1||value.indexOf("&")!=-1||value.indexOf("=")!=-1||value.indexOf("?")!=-1)
		searchRequestStr += "&searchTerm="+escape(value);
	else
		searchRequestStr += "&searchTerm="+value;
	searchRequestStr += "&searchField="+getQueryField(search_currentChoice,"searchfield");
	var caption = "&tabCaption=";
	var label = "";
	var labelKey = "";
	for(i in static_searchFields) {
		if(static_searchFields[i][1] == search_currentChoice) {
			label = (belenusHome.ld[static_searchFields[i][0]]) ? belenusHome.ld[static_searchFields[i][0]] : escape(static_searchFields[i][0]);
			labelKey = (belenusHome.ld[static_searchFields[i][0]]) ? static_searchFields[i][0] : "";
			break;
		}
	}
	var id4MultiLangLabel0 = "m0"+Math.random();
	var id4MultiLangLabel1 = "m1"+Math.random();
	var id4MultiLangLabel2 = "m2"+Math.random();
	belenusHome.addLKey(id4MultiLangLabel0,belenusHome.frames.TabMainFrame.frames.caption_bar,"","nav_search");
	if(labelKey!="")belenusHome.addLKey(id4MultiLangLabel1,belenusHome.frames.TabMainFrame.frames.caption_bar,"",labelKey);
	belenusHome.addLKey(id4MultiLangLabel2,belenusHome.frames.TabMainFrame.frames.tabs_bar,"","nav_search");
//	caption += escape("longTabCaption=<span "+escape(escape('id='+id4MultiLangLabel0))+">"+belenusHome.ld['nav_search']+ '</span> ( <span '+escape(escape('id='+id4MultiLangLabel1))+'>'+label+'</span>: '+value+' )&shortTabCaption=<span '+escape(escape('id='+id4MultiLangLabel2))+'>'+belenusHome.ld['nav_search']+"</span> ( "+value+" )");
	caption += escape("longTabCaption=belenusHome.ld['nav_search']+' ( '+belenusHome.ld[\""+labelKey+"\"]+': "+((value.indexOf("&")!=-1 || value.indexOf("=")!=-1)?escape(value):value)+" )'&shortTabCaption=belenusHome.ld['nav_search']+' ( "+((value.indexOf("&")!=-1 || value.indexOf("=")!=-1)?escape(value):value)+" )'");
	searchRequestStr += caption;
	if(belenusHome.useTabManager == false || belenusHome.Windows['search'][5] == "") {
		try {
			if(belenusHome.WM.getWindowReference('search').closed == false) belenusHome.WM.closeWindow('search');
		} catch(e) { }
	}
	belenusHome.WM.openWindow('search',searchRequestStr,false);
}



// used by static and dynamic
var search_currentChoice = null;
function search_showInputField(winRef,name) {
	if(belenusHome.interpartsVersion == "dynamic") {
		for(i in dynamic_searchFields) belenusHome.id(winRef.document,dynamic_searchFields[i][1]).style.display="none";
		belenusHome.id(winRef.document,name).style.display="inline";
		belenusHome.id(winRef.document,name+'_0').focus();
		belenusHome.id(winRef.document,name+'_0').select();
	} else {
		for(i in static_searchFields) belenusHome.id(winRef.document,static_searchFields[i][1]).style.display="none";
		belenusHome.id(winRef.document,name).style.display="inline";
		belenusHome.id(winRef.document,name+'_0').focus();
		belenusHome.id(winRef.document,name+'_0').select();
	}
}
function search_showDD(winRef,name) {
	if(belenusHome.interpartsVersion == "dynamic") {
		var DD = belenusHome.id(winRef.document,'SDD');
		for(var j = 0; j < DD.options.length; j++) {
			if(DD.options[j].value == name) { DD.selectedIndex = j;break; }
		}
	} else {
		var DD = belenusHome.id(winRef.document,'SDD');
		for(var j = 0; j < DD.options.length; j++) {
			if(DD.options[j].value == name) { DD.selectedIndex = j;break; }
		}

	}
}
function search_showSearchOption(winRef,name) {
//	try {
		if(belenusHome.searchMode != null) {
			search_showInputField(winRef,name);
			search_showDD(winRef,name);
			search_currentChoice = name;
		}
//	} catch(e) {
		//nothing
//	}
}
